import { DataTypes } from 'sequelize';
import { INVOICE_ITEMS_DISCOUNT_TYPES, SYNC_DIRECTIONS } from '@tamanu/constants';
import { buildEncounterLinkedSyncFilter } from '../sync/buildEncounterLinkedSyncFilter';
import { Model } from './Model';
import { buildEncounterLinkedLookupJoins, buildEncounterLinkedLookupSelect } from '../sync/buildEncounterLinkedLookupFilter';
const INVOICE_ITEMS_DISCOUNT_TYPE_VALUES = Object.values(INVOICE_ITEMS_DISCOUNT_TYPES);
export class InvoiceItemDiscount extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            amount: {
                type: DataTypes.DECIMAL,
                allowNull: false
            },
            type: {
                type: DataTypes.ENUM(...INVOICE_ITEMS_DISCOUNT_TYPE_VALUES),
                allowNull: false,
                defaultValue: INVOICE_ITEMS_DISCOUNT_TYPES.PERCENTAGE
            },
            reason: DataTypes.STRING
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.InvoiceItem, {
            foreignKey: 'invoiceItemId',
            as: 'invoiceItem'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return buildEncounterLinkedSyncFilter([
            this.tableName,
            'invoice_items',
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await buildEncounterLinkedLookupSelect(this),
            joins: buildEncounterLinkedLookupJoins(this, [
                'invoice_items',
                'invoices',
                'encounters'
            ])
        };
    }
}

//# sourceMappingURL=InvoiceItemDiscount.js.map