function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import { DataTypes } from 'sequelize';
import { FHIR_INTERACTIONS } from '@tamanu/constants';
import { FhirResource } from './Resource';
import { getQueryOptions, getValues, fromAdministeredVaccines, searchParameters } from '../../utils/fhir/Immunization';
export class FhirImmunization extends FhirResource {
    static initModel(options, models) {
        super.initResource({
            status: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            vaccineCode: {
                type: DataTypes.JSONB,
                allowNull: false
            },
            patient: {
                type: DataTypes.JSONB,
                allowNull: false
            },
            encounter: {
                type: DataTypes.JSONB,
                allowNull: true
            },
            occurrenceDateTime: DataTypes.TEXT,
            lotNumber: DataTypes.TEXT,
            site: DataTypes.JSONB,
            performer: DataTypes.JSONB,
            protocolApplied: DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.AdministeredVaccine
        ];
        this.upstreams = [
            models.AdministeredVaccine,
            models.Encounter,
            models.Patient,
            models.ReferenceData,
            models.ScheduledVaccine,
            models.User
        ];
        this.referencedResources = [
            models.FhirPatient,
            models.FhirEncounter,
            models.FhirPractitioner
        ];
    }
    async updateMaterialisation() {
        const upstream = await this.getUpstream(getQueryOptions(this.sequelize.models));
        const values = await getValues(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id) {
        const { AdministeredVaccine } = this.sequelize.models;
        if (upstreamTable === AdministeredVaccine.tableName) {
            return fromAdministeredVaccines(this.sequelize.models, table, id);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ...searchParameters
        };
    }
}
_define_property(FhirImmunization, "CAN_DO", new Set([
    FHIR_INTERACTIONS.INSTANCE.READ,
    FHIR_INTERACTIONS.TYPE.SEARCH,
    FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=FhirImmunization.js.map