import type { SyncHookSnapshotChanges, SyncSnapshotAttributes } from 'types/sync';
import type { Patient } from 'models';
/**
 * Resolve duplicated patient display IDs by
 * 1. Creating a new incoming snapshot change for the existing patient's display ID and append '_duplicate_1'
 * 2. Append '_duplicate_2' to the display ID of the to-be-synced patient
 *
 * The new changes will be persisted in the sync_snapshot table
 * @param sequelize
 * @param sessionId
 * @param PatientModel
 * @param changes
 */
export declare const resolveDuplicatedPatientDisplayIds: (PatientModel: typeof Patient, changes: SyncSnapshotAttributes[]) => Promise<SyncHookSnapshotChanges | undefined>;
//# sourceMappingURL=resolveDuplicatedPatientDisplayIds.d.ts.map