import { Transaction } from 'sequelize';
const wrapTransaction = async (sequelize, options = {}, // eslint-disable-next-line no-unused-vars
executeWithinTransaction)=>{
    return sequelize.transaction(options, async (transaction)=>{
        // transaction does not actually start until the first query is executed,
        // so just select 1 here to start the transaction as soon as possible
        await sequelize.query('SELECT 1;', {
            transaction
        });
        return executeWithinTransaction(transaction);
    });
};
export const repeatableReadTransaction = async (sequelize, // eslint-disable-next-line no-unused-vars
executeWithinTransaction)=>wrapTransaction(sequelize, {
        isolationLevel: Transaction.ISOLATION_LEVELS.REPEATABLE_READ
    }, executeWithinTransaction);
export const readOnlyTransaction = async (sequelize, // eslint-disable-next-line no-unused-vars
executeWithinTransaction)=>{
    return wrapTransaction(sequelize, {}, async (transaction)=>{
        // Set the transaction to read-only mode
        await sequelize.query('SET TRANSACTION READ ONLY;', {
            transaction
        });
        return executeWithinTransaction(transaction);
    });
};

//# sourceMappingURL=transactions.js.map