"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    BaseValidationError: function() {
        return BaseValidationError;
    },
    ValidationError: function() {
        return ValidationError;
    }
});
const _BaseError = require("../BaseError");
const _constants = require("../constants");
let BaseValidationError = class BaseValidationError extends _BaseError.BaseError {
    constructor(type, title, detail){
        super(type, title, 422, detail);
    }
};
let ValidationError = class ValidationError extends BaseValidationError {
    constructor(detail){
        super(_constants.ERROR_TYPE.VALIDATION, 'Validation', detail);
    }
};

//# sourceMappingURL=ValidationError.js.map