<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function ctranspose

Transpose and complex conjugate a matrix. All values of the matrix are
reflected over its main diagonal and then the complex conjugate is
taken. This is equivalent to complex conjugation for scalars and
vectors.


## Syntax

```js
math.ctranspose(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Array &#124; Matrix | Matrix to be ctransposed

### Returns

Type | Description
---- | -----------
Array &#124; Matrix | The ctransposed matrix


## Examples

```js
const A = [[1, 2, 3], [4, 5, math.complex(6,7)]]
math.ctranspose(A)               // returns [[1, 4], [2, 5], [3, {re:6,im:7}]]
```


## See also

[transpose](transpose.md),
[diag](diag.md),
[inv](inv.md),
[subset](subset.md),
[squeeze](squeeze.md)
