"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    extractDefaults: function() {
        return extractDefaults;
    },
    isSetting: function() {
        return isSetting;
    },
    isSettingsSchema: function() {
        return isSettingsSchema;
    }
});
const _lodash = require("lodash");
const isSetting = (value)=>{
    return value && (0, _lodash.isObject)(value) && 'type' in value && 'defaultValue' in value;
};
const isSettingsSchema = (value)=>{
    return value && (0, _lodash.isObject)(value) && 'properties' in value;
};
const extractDefaults = (settings)=>{
    const result = (0, _lodash.mapValues)(settings.properties, (value)=>isSetting(value) ? value.defaultValue : extractDefaults(value));
    return (0, _lodash.omitBy)(result, _lodash.isUndefined);
};

//# sourceMappingURL=utils.js.map