"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createSessionIdentifier", {
    enumerable: true,
    get: function() {
        return createSessionIdentifier;
    }
});
const _crypto = /*#__PURE__*/ _interop_require_default(require("crypto"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function createSessionIdentifier(token) {
    // Creates a unique session identifier from the token
    return _crypto.default.createHash('sha256').update(token).digest('hex').slice(-32);
}

//# sourceMappingURL=createSessionIdentifier.js.map