"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "resourcesThatCanDo", {
    enumerable: true,
    get: function() {
        return resourcesThatCanDo;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function resourcesThatCanDo(models, ...interactions) {
    return Object.values(models).filter((Resource)=>interactions.every((interaction)=>{
            // Check if materialisation of resource is enabled
            if (!_config.default.integrations.fhir.worker.enabled || interaction === _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE && !_config.default.integrations.fhir.worker.resourceMaterialisationEnabled[Resource.fhirName]) {
                return false;
            }
            return Resource.CAN_DO?.has(interaction);
        }));
}

//# sourceMappingURL=resources.js.map