"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "tmpdir", {
    enumerable: true,
    get: function() {
        return tmpdir;
    }
});
const _os = /*#__PURE__*/ _interop_require_default(require("os"));
const _path = /*#__PURE__*/ _interop_require_default(require("path"));
const _mkdirp = /*#__PURE__*/ _interop_require_default(require("mkdirp"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function tmpdir() {
    const dir = _path.default.resolve(_os.default.tmpdir());
    await (0, _mkdirp.default)(dir); // on windows, os.tmpdir() can return a non-existent folder
    return dir;
}

//# sourceMappingURL=tmpdir.js.map