import React from 'react';
import { Document, StyleSheet, View } from '@react-pdf/renderer';
import { CertificateHeader, styles, Watermark } from './Layout';
import { ageInYears, getCurrentDateString } from '@tamanu/utils/dateTime';
import { LetterheadSection } from './LetterheadSection';
import { ATTENDANT_OF_BIRTH_OPTIONS, BIRTH_DELIVERY_TYPE_OPTIONS, BIRTH_TYPE_OPTIONS, MARITAL_STATUS_OPTIONS, PLACE_OF_BIRTH_OPTIONS, SEX_OPTIONS } from '@tamanu/constants';
import { Footer } from './printComponents/Footer';
import { getDisplayDate } from './getDisplayDate';
import { getEthnicity } from '../patientAccessors';
import { useLanguageContext, withLanguageContext } from '../pdf/languageContext';
import { Page } from '../pdf/Page';
import { Text } from '../pdf/Text';
const borderStyle = '1 solid black';
const topStyles = StyleSheet.create({
    container: {
        flexDirection: 'row',
        justifyContent: 'space-between',
        marginTop: 15
    },
    cell: {
        flexDirection: 'row',
        marginBottom: 10
    },
    key: {
        fontSize: 9,
        marginRight: 2
    },
    value: {
        fontSize: 9
    }
});
const TopSection = ({ facilityName, childDisplayId })=>{
    const date = getCurrentDateString();
    return /*#__PURE__*/ React.createElement(View, {
        style: topStyles.container
    }, /*#__PURE__*/ React.createElement(View, {
        style: topStyles.cell
    }, /*#__PURE__*/ React.createElement(P, {
        style: topStyles.key
    }, "Facility:"), /*#__PURE__*/ React.createElement(P, {
        style: topStyles.value
    }, facilityName)), /*#__PURE__*/ React.createElement(View, {
        style: topStyles.cell
    }, /*#__PURE__*/ React.createElement(P, {
        bold: true,
        style: topStyles.key
    }, "Notification date:"), /*#__PURE__*/ React.createElement(P, {
        style: topStyles.value
    }, getDisplayDate(date))), /*#__PURE__*/ React.createElement(View, {
        style: topStyles.cell
    }, /*#__PURE__*/ React.createElement(P, {
        style: topStyles.key
    }, "Child ID:"), /*#__PURE__*/ React.createElement(P, {
        style: topStyles.value
    }, childDisplayId)));
};
const tableStyles = StyleSheet.create({
    table: {
        flexDirection: 'column',
        marginBottom: 15
    },
    row: {
        flexDirection: 'row',
        justifyContent: 'space-evenly',
        borderTop: borderStyle,
        borderBottom: borderStyle,
        borderRight: borderStyle,
        marginBottom: -1
    },
    baseCell: {
        flexDirection: 'row',
        borderLeft: borderStyle,
        alignItems: 'center',
        padding: 5
    },
    flexCell: {
        flex: 1
    },
    leftCell: {
        width: '125pt'
    },
    p: {
        fontSize: 9
    }
});
const Table = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: tableStyles.table,
        ...props
    });
const Row = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: tableStyles.row,
        ...props
    });
const P = ({ style = {}, bold, children })=>/*#__PURE__*/ React.createElement(Text, {
        bold: bold,
        style: [
            tableStyles.p,
            style
        ]
    }, children);
const FlexCell = ({ children, style = {}, bold = false })=>/*#__PURE__*/ React.createElement(View, {
        style: [
            tableStyles.baseCell,
            tableStyles.flexCell,
            style
        ]
    }, /*#__PURE__*/ React.createElement(P, {
        bold: bold
    }, children));
const Cell = ({ children, style = {}, bold })=>/*#__PURE__*/ React.createElement(View, {
        style: [
            tableStyles.baseCell,
            style
        ]
    }, /*#__PURE__*/ React.createElement(P, {
        bold: bold
    }, children));
const LeftCell = ({ children })=>/*#__PURE__*/ React.createElement(View, {
        style: [
            tableStyles.baseCell,
            tableStyles.leftCell
        ]
    }, /*#__PURE__*/ React.createElement(P, {
        bold: true
    }, children));
const getLabelFromValue = (mapping, v)=>{
    const entry = mapping.find((e)=>e.value === v);
    return entry ? entry.label : '';
};
const getFullName = (patient)=>`${patient?.firstName ?? ''} ${patient?.lastName ?? ''}`;
const ChildSection = ({ data })=>{
    const { getTranslation } = useLanguageContext();
    const causeOfDeath = data?.deathData?.causes?.primary?.condition?.name ?? getTranslation('general.fallback.notApplicable', 'N/A');
    return /*#__PURE__*/ React.createElement(Table, null, /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(FlexCell, {
        bold: true
    }, getTranslation('pdf.birthNotification.child.label', 'Child'))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('pdf.birthNotification.nameIfKnown.label', 'Name (if known)')), /*#__PURE__*/ React.createElement(FlexCell, null, getFullName(data))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('pdf.birthNotification.gestationWeeks.label', 'Gestation (weeks)')), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 50
        }
    }, data?.birthData?.gestationalAgeEstimate), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 80
        },
        bold: true
    }, getTranslation('general.localisedField.birthDeliveryType.label', 'Delivery type')), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 70
        }
    }, getLabelFromValue(BIRTH_DELIVERY_TYPE_OPTIONS, data?.birthData?.birthDeliveryType)), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 100
        },
        bold: true
    }, getTranslation('pdf.birthNotification.singlePluralBirths.label', 'Single/plural births')), /*#__PURE__*/ React.createElement(FlexCell, null, getLabelFromValue(BIRTH_TYPE_OPTIONS, data?.birthData?.birthType))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('pdf.birthNotification.birthWeightKg.label', 'Birth Weight (kg)')), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 50
        }
    }, data?.birthData?.birthWeight), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 80
        },
        bold: true
    }, getTranslation('pdf.birthNotification.birthDate.label', 'Birth date')), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 70
        }
    }, data?.dateOfBirth ? getDisplayDate(data?.dateOfBirth) : ''), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 100
        },
        bold: true
    }, getTranslation('pdf.birthNotification.birthTime.label', 'Birth time')), /*#__PURE__*/ React.createElement(FlexCell, null, data?.birthData?.timeOfBirth ? getDisplayDate(data?.birthData?.timeOfBirth, 'hh:mm a') : '')), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('general.localisedField.registeredBirthPlace.label', 'Place of birth')), /*#__PURE__*/ React.createElement(FlexCell, null, getLabelFromValue(PLACE_OF_BIRTH_OPTIONS, data?.birthData?.registeredBirthPlace))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('general.localisedField.sex.label', 'Sex')), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 130
        }
    }, getLabelFromValue(SEX_OPTIONS, data?.sex)), /*#__PURE__*/ React.createElement(FlexCell, {
        bold: true
    }, getTranslation('general.localisedField.ethnicityId.label', 'Ethnicity')), /*#__PURE__*/ React.createElement(FlexCell, null, getEthnicity(data))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('general.localisedField.attendantAtBirth.label', 'Attendant at birth')), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 130
        }
    }, getLabelFromValue(ATTENDANT_OF_BIRTH_OPTIONS, data?.birthData?.attendantAtBirth)), /*#__PURE__*/ React.createElement(FlexCell, {
        bold: true
    }, getTranslation('general.localisedField.nameOfAttendantAtBirth.label', 'Name of attendant')), /*#__PURE__*/ React.createElement(FlexCell, null, data?.birthData?.nameOfAttendantAtBirth)), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('pdf.birthNotification.causeOfFoetalDeath.label', 'Cause of foetal death')), /*#__PURE__*/ React.createElement(FlexCell, null, causeOfDeath)));
};
const ParentSection = ({ parentType, data = {} })=>{
    const { getTranslation } = useLanguageContext();
    return /*#__PURE__*/ React.createElement(Table, null, /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(FlexCell, {
        bold: true
    }, parentType)), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('general.name.label', 'Name')), /*#__PURE__*/ React.createElement(FlexCell, null, getFullName(data))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('general.localisedField.ethnicityId.label', 'Ethnicity')), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 150
        }
    }, getEthnicity(data)), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, getTranslation('general.localisedField.nationalityId.label', 'Nationality')), /*#__PURE__*/ React.createElement(FlexCell, null, data?.additionalData?.nationality?.name)), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('general.localisedField.dateOfBirth.label', 'Date of birth')), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 150
        }
    }, data?.dateOfBirth ? getDisplayDate(data?.dateOfBirth) : ''), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, getTranslation('general.localisedField.maritalStatus.label', 'Marital status')), /*#__PURE__*/ React.createElement(FlexCell, null, getLabelFromValue(MARITAL_STATUS_OPTIONS, data?.additionalData?.maritalStatus))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('general.localisedField.occupationId.label', 'Occupation')), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 150
        }
    }, data?.occupation?.name), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, getTranslation('pdf.birthNotification.age.label', 'Age')), /*#__PURE__*/ React.createElement(FlexCell, null, data?.dateOfBirth ? ageInYears(data.dateOfBirth) : '')), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('pdf.birthNotification.address.label', 'Address')), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 150
        }
    }, data?.additionalData?.streetVillage), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, getTranslation('general.localisedField.villageId.label', 'Village')), /*#__PURE__*/ React.createElement(FlexCell, null, data?.village?.name)), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('pdf.birthNotification.motherName.label', "Mother's name")), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 150
        }
    }, getFullName(data?.mother)), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, getTranslation('general.patientId.label', 'Patient ID')), /*#__PURE__*/ React.createElement(FlexCell, null, data?.displayId)), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, getTranslation('pdf.birthNotification.fatherName.label', "Father's name")), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 150
        }
    }, getFullName(data?.father)), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, getTranslation('pdf.birthNotification.phoneNumber.label', 'Phone number')), /*#__PURE__*/ React.createElement(FlexCell, null, data?.additionalData?.primaryContactNumber)));
};
const signatureStyles = StyleSheet.create({
    container: {
        flexDirection: 'row',
        marginTop: 10
    },
    leftCell: {
        flexDirection: 'row',
        marginBottom: 15,
        paddingRight: 10
    },
    rightCell: {
        flexDirection: 'row',
        marginBottom: 15,
        paddingLeft: 10
    },
    leftText: {
        width: 90,
        marginRight: 10
    },
    rightText: {
        width: 30,
        marginRight: 10
    },
    line: {
        flex: 1,
        borderBottom: '1 solid black'
    }
});
const SignatureSection = ()=>{
    const { getTranslation } = useLanguageContext();
    return /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.container
    }, /*#__PURE__*/ React.createElement(View, {
        style: {
            flex: 1
        }
    }, /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.leftCell
    }, /*#__PURE__*/ React.createElement(P, {
        bold: true,
        style: signatureStyles.leftText
    }, getTranslation('pdf.birthNotification.signature.certifiedCorrectBy', 'Certified correct by'), ":"), /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.line
    })), /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.leftCell
    }, /*#__PURE__*/ React.createElement(P, {
        bold: true,
        style: signatureStyles.leftText
    }, getTranslation('pdf.birthNotification.signature.circleApplicable', 'Circle applicable'), ":"), /*#__PURE__*/ React.createElement(P, {
        bold: true
    }, getTranslation('pdf.birthNotification.signature.doctorMidwifeNurse', 'Doctor/midwife/nurse')))), /*#__PURE__*/ React.createElement(View, {
        style: {
            flex: 1
        }
    }, /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.rightCell
    }, /*#__PURE__*/ React.createElement(P, {
        bold: true,
        style: signatureStyles.rightText
    }, getTranslation('pdf.birthNotification.signature.signed', 'Signed') + ':'), /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.line
    })), /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.rightCell
    }, /*#__PURE__*/ React.createElement(P, {
        bold: true,
        style: signatureStyles.rightText
    }, getTranslation('pdf.birthNotification.signature.date', 'Date'), ":"), /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.line
    }))));
};
const BirthNotificationCertificateComponent = ({ motherData, fatherData, childData, facility, certificateData })=>{
    const { logo, watermark } = certificateData;
    const { getTranslation } = useLanguageContext();
    return /*#__PURE__*/ React.createElement(Document, null, /*#__PURE__*/ React.createElement(Page, {
        size: "A4",
        style: styles.page
    }, watermark && /*#__PURE__*/ React.createElement(Watermark, {
        src: watermark
    }), /*#__PURE__*/ React.createElement(CertificateHeader, null, /*#__PURE__*/ React.createElement(LetterheadSection, {
        logoSrc: logo,
        certificateTitle: getTranslation('pdf.birthNotification.title', 'Birth Notification'),
        letterheadConfig: certificateData
    })), /*#__PURE__*/ React.createElement(TopSection, {
        facilityName: facility?.name,
        childDisplayId: childData?.displayId
    }), /*#__PURE__*/ React.createElement(ParentSection, {
        parentType: getTranslation('general.localisedField.motherId.label', 'Mother'),
        data: motherData
    }), /*#__PURE__*/ React.createElement(ParentSection, {
        parentType: getTranslation('general.localisedField.fatherId.label', 'Father'),
        data: fatherData
    }), /*#__PURE__*/ React.createElement(ChildSection, {
        data: childData
    }), /*#__PURE__*/ React.createElement(SignatureSection, null), /*#__PURE__*/ React.createElement(Footer, null)));
};
export const BirthNotificationCertificate = withLanguageContext(BirthNotificationCertificateComponent);

//# sourceMappingURL=BirthNotificationCertificate.js.map