import React from 'react';
import { StyleSheet, View } from '@react-pdf/renderer';
import { Text } from '../pdf/Text';
const basicBorder = '1 solid black';
const tableStyles = StyleSheet.create({
    tr: {
        flexDirection: 'row',
        flexWrap: 'wrap',
        borderBottom: basicBorder,
        borderTop: basicBorder,
        marginBottom: -1
    },
    th: {
        flex: 1,
        fontSize: 10,
        fontWeight: 700,
        padding: 3,
        borderRight: basicBorder,
        margin: 0
    },
    td: {
        flex: 1,
        padding: 3,
        fontSize: 10,
        margin: 0,
        borderRight: basicBorder
    }
});
const TR = (props)=>/*#__PURE__*/ React.createElement(View, {
        ...props,
        style: tableStyles.tr
    });
const TH = ({ customStyles, ...props })=>/*#__PURE__*/ React.createElement(Text, {
        bold: true,
        ...props,
        style: [
            tableStyles.th,
            customStyles
        ]
    });
const TD = ({ customStyles, ...props })=>/*#__PURE__*/ React.createElement(Text, {
        wrap: false,
        ...props,
        style: [
            tableStyles.td,
            customStyles
        ]
    });
export const Table = ({ data, columns, getLocalisation, getSetting, columnStyle })=>{
    const leftColumnStyle = {
        ...columnStyle,
        borderLeft: basicBorder
    };
    const visibleColumns = columns.filter(({ key })=>getSetting(`fields.${key}.hidden`) !== true);
    return /*#__PURE__*/ React.createElement(View, {
        style: tableStyles.table
    }, /*#__PURE__*/ React.createElement(TR, {
        fixed: true
    }, visibleColumns.map(({ title, key, customStyles }, columnIndex)=>/*#__PURE__*/ React.createElement(TH, {
            key: key,
            customStyles: [
                customStyles,
                columnIndex === 0 ? leftColumnStyle : columnStyle
            ]
        }, title))), data.map((row, rowIndex)=>// eslint-disable-next-line react/no-array-index-key
        /*#__PURE__*/ React.createElement(TR, {
            key: rowIndex
        }, visibleColumns.map(({ accessor, key, customStyles }, columnIndex)=>/*#__PURE__*/ React.createElement(TD, {
                key: key,
                customStyles: [
                    customStyles,
                    columnIndex === 0 ? leftColumnStyle : columnStyle
                ]
            }, accessor ? accessor(row, getLocalisation, getSetting) : row[key])))));
};

//# sourceMappingURL=Table.js.map