import React from 'react';
import { DataSection } from './DataSection';
import { DataItem } from './DataItem';
import { getLocationName } from '../../patientAccessors';
import { Col } from '../Layout';
import { HorizontalRule } from './HorizontalRule';
export const EncounterDetails = ({ encounter })=>{
    const { location, department } = encounter || {};
    return /*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(DataSection, {
        title: "Encounter details",
        hideBottomRule: true
    }, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: "Facility",
        value: location?.facility?.name
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: "Location",
        value: getLocationName(encounter)
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: "Department",
        value: department?.name
    }))), /*#__PURE__*/ React.createElement(HorizontalRule, {
        width: "2px"
    }));
};

//# sourceMappingURL=EncounterDetails.js.map