"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getVersionIncompatibleMessage", {
    enumerable: true,
    get: function() {
        return getVersionIncompatibleMessage;
    }
});
const _constants = require("@tamanu/constants");
const VERSION_COMPAT_MESSAGE_LOW = 'Tamanu is out of date, reload to get the new version! If that does not work, contact your system administrator.';
const VERSION_COMPAT_MESSAGE_HIGH = (maxAppVersion)=>`The Tamanu Facility Server only supports up to v${maxAppVersion}, and needs to be upgraded. Please contact your system administrator.`;
function getVersionIncompatibleMessage(problem) {
    if (problem.detail === _constants.VERSION_COMPATIBILITY_ERRORS.LOW) {
        return VERSION_COMPAT_MESSAGE_LOW;
    }
    if (problem.detail === _constants.VERSION_COMPATIBILITY_ERRORS.HIGH) {
        const maxAppVersion = problem.extra.get(_constants.VERSION_MAXIMUM_PROBLEM_KEY);
        return VERSION_COMPAT_MESSAGE_HIGH(maxAppVersion);
    }
    return null;
}

//# sourceMappingURL=getVersionIncompatibleMessage.js.map