"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getBundleEntryFromResource: function() {
        return getBundleEntryFromResource;
    },
    getEntryResourceSubject: function() {
        return getEntryResourceSubject;
    },
    getPatientDisplayName: function() {
        return getPatientDisplayName;
    }
});
const getPatientDisplayName = (patient)=>[
        patient.firstName,
        patient.lastName
    ].filter((x)=>x).join(' ');
const getEntryResourceSubject = (patient)=>({
        reference: `urn:uuid:${patient.id}`,
        display: getPatientDisplayName(patient)
    });
const getBundleEntryFromResource = (resource)=>({
        fullUrl: `urn:uuid:${resource.id}`,
        resource
    });

//# sourceMappingURL=utils.js.map