import { z } from 'zod';
export declare const SurveySchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    code: z.ZodString;
    surveyType: z.ZodEnum<{
        PROGRAMS: string;
        REFERRAL: string;
        OBSOLETE: string;
        VITALS: string;
        SIMPLE_CHART: string;
        COMPLEX_CHART: string;
        COMPLEX_CHART_CORE: string;
    }>;
}, z.core.$strip>;
export type Survey = z.infer<typeof SurveySchema>;
//# sourceMappingURL=survey.schema.d.ts.map