"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    deleteDocumentMetadata: function() {
        return deleteDocumentMetadata;
    },
    deleteEncounter: function() {
        return deleteEncounter;
    },
    deleteReferral: function() {
        return deleteReferral;
    },
    deleteSurveyResponse: function() {
        return deleteSurveyResponse;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _errors = require("@tamanu/errors");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const deleteModel = (modelName, paramName, displayName = modelName)=>{
    return (0, _expressasynchandler.default)(async (req, res)=>{
        const { models, params } = req;
        req.checkPermission('delete', modelName);
        const model = models[modelName];
        const primaryKey = params[paramName];
        const object = await model.findByPk(primaryKey);
        if (!object) {
            throw new _errors.NotFoundError(`Cannot find ${displayName.toLowerCase()} with id ${primaryKey}`);
        }
        req.checkPermission('delete', object);
        await object.destroy();
        res.send({
            message: `${displayName} deleted successfully`
        });
    });
};
const deleteEncounter = deleteModel('Encounter', 'id');
const deleteReferral = deleteModel('Referral', 'referralId');
const deleteSurveyResponse = deleteModel('SurveyResponse', 'surveyResponseId', 'Survey response');
const deleteDocumentMetadata = deleteModel('DocumentMetadata', 'documentMetadataId', 'Document');

//# sourceMappingURL=deleteModel.js.map