"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE = {
    tableName: 'accesses',
    schema: 'logs'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        user_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            references: {
                model: {
                    tableName: 'users',
                    schema: 'public'
                },
                key: 'id'
            }
        },
        record_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        record_type: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        facility_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true,
            references: {
                model: {
                    tableName: 'facilities',
                    schema: 'public'
                },
                key: 'id'
            }
        },
        session_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        device_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        logged_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false
        },
        front_end_context: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: false
        },
        back_end_context: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: false
        },
        is_mobile: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: false
        },
        version: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        }
    });
}
async function down(query) {
    await query.dropTable(TABLE);
}

//# sourceMappingURL=1741225665058-createAccessLog.js.map