"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "DeathRevertLog", {
    enumerable: true,
    get: function() {
        return DeathRevertLog;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _errors = require("@tamanu/errors");
const _Model = require("./Model");
const _model = require("../types/model");
let DeathRevertLog = class DeathRevertLog extends _Model.Model {
    static initModel(options) {
        super.init({
            id: {
                type: _sequelize.DataTypes.UUID,
                allowNull: false,
                primaryKey: true,
                defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
            },
            revertTime: (0, _model.dateTimeType)('revertTime', {
                allowNull: false
            }),
            deathDataId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PUSH_TO_CENTRAL,
            validate: {
                mustHavePatient () {
                    if (!this.patientId) {
                        throw new _errors.InvalidOperationError('A death revert log must have a patient.');
                    }
                },
                mustHaveValidUser () {
                    if (!this.revertedById) {
                        throw new _errors.InvalidOperationError('A death revert log must register the user that triggered the revert.');
                    }
                }
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.User, {
            foreignKey: 'revertedById',
            as: 'revertedBy'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=DeathRevertLog.js.map