"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    initAppContext: function() {
        return initAppContext;
    },
    routes: function() {
        return routes;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _lodash = require("lodash");
const _errorHandler = require("../../middleware/errorHandler");
const _requireClientHeaders = require("../../middleware/requireClientHeaders");
const _VRSRemote = require("./VRSRemote");
const _VRSActionHandler = require("./VRSActionHandler");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const vrsErrorHandler = (0, _errorHandler.buildErrorHandler)((error)=>({
        response: false,
        error: {
            message: error.message,
            ...error
        }
    }));
const routes = _express.default.Router();
if (_config.default.integrations.fijiVrs.requireClientHeaders) {
    routes.use(_requireClientHeaders.requireClientHeaders);
}
routes.post('/hooks/patientCreated', (0, _expressasynchandler.default)(async (req, res)=>{
    const { body, ctx } = req;
    await ctx.integrations.fijiVrs.actionHandler.applyAction(body);
    res.send({
        response: true
    });
}));
routes.use(vrsErrorHandler);
const initAppContext = async (ctx)=>{
    const vrsConfig = _config.default.integrations.fijiVrs;
    const remote = new _VRSRemote.VRSRemote(ctx.store, vrsConfig);
    const actionHandler = new _VRSActionHandler.VRSActionHandler(ctx.store, remote, vrsConfig);
    (0, _lodash.set)(ctx, 'integrations.fijiVrs.remote', remote); // added to context to help make testing easier
    (0, _lodash.set)(ctx, 'integrations.fijiVrs.actionHandler', actionHandler);
};

//# sourceMappingURL=routes.js.map