"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getAttributesFromSchema", {
    enumerable: true,
    get: function() {
        return getAttributesFromSchema;
    }
});
const _zod = require("zod");
const unwrap = (schema)=>{
    while(schema instanceof _zod.z.ZodOptional || schema instanceof _zod.z.ZodNullable || schema instanceof _zod.z.ZodDefault){
        schema = schema.unwrap();
    }
    return schema;
};
const getAttributesFromSchema = (schema)=>{
    schema = unwrap(schema);
    if (!(schema instanceof _zod.z.ZodObject)) {
        throw new Error('Schema must be an instance of ZodObject');
    }
    return Object.keys(schema.shape).filter((key)=>!(unwrap(schema.shape[key]) instanceof _zod.z.ZodObject));
};

//# sourceMappingURL=schemaUtils.js.map