"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirOrganization", {
    enumerable: true,
    get: function() {
        return FhirOrganization;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("./Resource");
const _Organization = require("../../utils/fhir/Organization");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let FhirOrganization = class FhirOrganization extends _Resource.FhirResource {
    static initModel(options, models) {
        super.initResource({
            identifier: _sequelize.DataTypes.JSONB,
            name: _sequelize.DataTypes.TEXT,
            active: _sequelize.DataTypes.BOOLEAN
        }, options);
        this.UpstreamModels = [
            models.Facility
        ];
        this.upstreams = [
            models.Facility
        ];
    }
    async updateMaterialisation() {
        const upstream = await this.getUpstream((0, _Organization.getQueryOptions)());
        const values = await (0, _Organization.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id) {
        const { Facility } = this.sequelize.models;
        if (upstreamTable === Facility.tableName) {
            return (0, _Organization.fromFacilities)(this.sequelize.models, table, id);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._Organization.searchParameters
        };
    }
};
_define_property(FhirOrganization, "CAN_DO", new Set([
    _constants.FHIR_INTERACTIONS.INSTANCE.READ,
    _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
    _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=FhirOrganization.js.map