"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "queryTranslatedStringsByLanguage", {
    enumerable: true,
    get: function() {
        return queryTranslatedStringsByLanguage;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const EXCLUDE_REFERENCE_DATA_CLAUSE = `WHERE string_id NOT LIKE '${_constants.REFERENCE_DATA_TRANSLATION_PREFIX}.%'`;
// Sort languages so that the default language is first
const sortLanguages = ({ language: a }, { language: b })=>{
    if (a === b) return 0;
    if (a === _constants.DEFAULT_LANGUAGE_CODE) return -1;
    if (b === _constants.DEFAULT_LANGUAGE_CODE) return 1;
    return a.localeCompare(b);
};
const queryTranslatedStringsByLanguage = async ({ sequelize, models, includeReferenceData = true })=>{
    const { TranslatedString } = models;
    const languagesInDb = await TranslatedString.findAll({
        attributes: [
            'language'
        ],
        group: 'language'
    });
    if (!languagesInDb.length) return [];
    const sortedLanguages = languagesInDb.sort(sortLanguages);
    const translations = await sequelize.query(`
      SELECT
          string_id as "stringId",
          ${sortedLanguages.map((_, index)=>`MAX(text) FILTER(WHERE language = $lang${index}) AS "lang${index}"`).join(',')}
      FROM
          translated_strings
      ${includeReferenceData ? '' : EXCLUDE_REFERENCE_DATA_CLAUSE}
      GROUP BY
          string_id
      ORDER BY
          string_id
      `, {
        bind: {
            ...Object.fromEntries(sortedLanguages.map(({ language }, index)=>[
                    `lang${index}`,
                    language
                ]))
        },
        type: _sequelize.QueryTypes.SELECT
    });
    // Because there is no way to escape the alias above, we need update the resulting
    // object to switch the dynamic alias to the expected alias which should exactly
    // match the language column from the translated string.
    const mappedTranslations = translations.map((row)=>{
        const newRow = {
            stringId: row.stringId
        };
        sortedLanguages.forEach(({ language }, index)=>{
            newRow[language] = row[`lang${index}`];
        });
        return newRow;
    });
    return mappedTranslations;
};

//# sourceMappingURL=queryTranslatedStringsByLanguage.js.map