"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.createTable('sync_session_records', {
        id: {
            type: _sequelize.default.UUID,
            defaultValue: _sequelize.default.UUIDV4,
            allowNull: false,
            primaryKey: true
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.default.DATE,
            allowNull: true
        },
        session_id: {
            type: _sequelize.default.UUID,
            references: {
                model: 'sync_sessions',
                key: 'id'
            },
            allowNull: false
        },
        direction: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        record_type: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        record_id: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        is_deleted: {
            type: _sequelize.default.BOOLEAN,
            allowNull: false
        },
        data: {
            type: _sequelize.default.JSON,
            allowNull: false
        }
    });
}
async function down(query) {
    await query.dropTable('sync_session_records');
}

//# sourceMappingURL=134_addSyncSessionRecordsTable.js.map