"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.changeColumn('settings', 'key', {
        type: _sequelize.DataTypes.TEXT,
        allowNull: false
    });
    await query.sequelize.query(`
    ALTER TABLE "settings"
      ALTER COLUMN "value"
        TYPE JSONB
          USING "value"::jsonb
  `);
}
async function down(query) {
    await query.changeColumn('settings', 'key', {
        type: _sequelize.DataTypes.STRING,
        allowNull: false
    });
    await query.changeColumn('settings', 'value', {
        type: _sequelize.DataTypes.STRING,
        allowNull: null
    });
}

//# sourceMappingURL=1673818192731-settingsJsonbValue.js.map