/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('notifications', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        type: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        status: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        created_time: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        metadata: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: false,
            defaultValue: {}
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
}
async function down(query) {
    await query.dropTable('notifications', {});
}

//# sourceMappingURL=1729413624614-addNotificationsTable.js.map