"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "RemoteUnreachableError", {
    enumerable: true,
    get: function() {
        return RemoteUnreachableError;
    }
});
const _constants = require("../constants");
const _RemoteError = require("./RemoteError");
let RemoteUnreachableError = class RemoteUnreachableError extends _RemoteError.BaseRemoteError {
    constructor(detail){
        super(_constants.ERROR_TYPE.REMOTE_UNREACHABLE, 'Remote unreachable', detail);
        if (detail?.includes('timeout')) {
            this.status = 504;
        }
    }
};

//# sourceMappingURL=RemoteUnreachableError.js.map