"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getProcedures", {
    enumerable: true,
    get: function() {
        return getProcedures;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _procedureschema = require("@tamanu/shared/schemas/patientPortal/responses/procedure.schema");
const _schemaUtils = require("../../utils/schemaUtils");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getProcedures = (0, _expressasynchandler.default)(async (req, res)=>{
    const { patient } = req;
    const { models } = req.store;
    const procedures = await models.Procedure.findAll({
        include: [
            {
                model: models.Encounter,
                as: 'encounter',
                attributes: [],
                where: {
                    patientId: patient.id
                },
                required: true
            },
            {
                model: models.ReferenceData,
                as: 'procedureType',
                attributes: (0, _schemaUtils.getAttributesFromSchema)(_procedureschema.ProcedureSchema.shape.procedureType)
            },
            {
                model: models.User,
                as: 'leadClinician',
                attributes: (0, _schemaUtils.getAttributesFromSchema)(_procedureschema.ProcedureSchema.shape.leadClinician)
            }
        ],
        attributes: (0, _schemaUtils.getAttributesFromSchema)(_procedureschema.ProcedureSchema)
    });
    res.send(procedures.map((procedure)=>_procedureschema.ProcedureSchema.parse(procedure.forResponse())));
});

//# sourceMappingURL=procedures.js.map