"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "fetchOrThrowIfUnavailable", {
    enumerable: true,
    get: function() {
        return fetchOrThrowIfUnavailable;
    }
});
const _errors = require("@tamanu/errors");
async function fetchOrThrowIfUnavailable(url, { fetch, timeout = false, ...config } = {}) {
    const abort = new AbortController();
    let timer;
    if (timeout && Number.isFinite(timeout) && !config.signal) {
        timer = setTimeout(()=>abort.abort(), timeout);
    }
    try {
        return await fetch(url, {
            signal: abort.signal,
            ...config
        }).finally(()=>{
            clearTimeout(timer);
        });
    } catch (e) {
        if (e instanceof Error && e.message === 'Failed to fetch') {
            // apply more helpful message if the server is not available
            throw new _errors.RemoteUnreachableError('The server is unavailable. Please check with your system administrator that the address is set correctly, and that it is running');
        }
        // some other unhandled error
        throw new _errors.RemoteUnreachableError(e.message);
    }
}

//# sourceMappingURL=fetch.js.map