import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
import { EncounterPrescription } from './EncounterPrescription';
export declare class Prescription extends Model {
    id: string;
    isOngoing?: boolean;
    isPrn?: boolean;
    isVariableDose?: boolean;
    doseAmount: string;
    units: string;
    frequency: string;
    idealTimes?: string[];
    route: string;
    date: string;
    startDate: string;
    endDate?: string;
    durationValue?: string | null;
    durationUnit?: string | null;
    indication?: string;
    isPhoneOrder?: boolean;
    notes?: string;
    pharmacyNotes?: string;
    displayPharmacyNotesInMar?: boolean;
    quantity?: number;
    discontinued?: boolean;
    discontinuedDate?: string;
    discontinuingReason?: string;
    repeats?: number;
    prescriberId?: string;
    discontinuingClinicianId?: string;
    medicationId?: string;
    encounterPrescription?: EncounterPrescription;
    static initModel({ primaryKey, ...options }: InitOptions, models: Models): void;
    static initRelations(models: Models): void;
    static getListReferenceAssociations(): string[];
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
}
//# sourceMappingURL=Prescription.d.ts.map