import { DataTypes, Sequelize } from 'sequelize';
export async function up(query) {
    await query.createTable('devices', {
        id: {
            type: DataTypes.TEXT,
            allowNull: false,
            primaryKey: true,
            defaultValue: Sequelize.fn('gen_random_uuid')
        },
        created_at: {
            type: DataTypes.DATE,
            allowNull: false,
            defaultValue: Sequelize.fn('now')
        },
        updated_at: {
            type: DataTypes.DATE,
            allowNull: false,
            defaultValue: Sequelize.fn('now')
        },
        deleted_at: {
            type: DataTypes.DATE,
            allowNull: true
        },
        last_seen_at: {
            type: DataTypes.DATE,
            allowNull: false,
            defaultValue: Sequelize.fn('now')
        },
        registered_by_id: {
            type: DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        name: {
            type: DataTypes.TEXT,
            allowNull: true
        }
    });
}
export async function down(query) {
    await query.dropTable('devices');
}

//# sourceMappingURL=1755562640175-createDevicesTable.js.map