function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import { DataTypes } from 'sequelize';
import { FHIR_INTERACTIONS } from '@tamanu/constants';
import { FhirResource } from './Resource';
import { filterFromLabRequests, fromLabRequest, getQueryOptions, getValues, searchParameters } from '../../utils/fhir/Specimen';
export class FhirSpecimen extends FhirResource {
    static initModel(options, models) {
        super.initResource({
            collection: DataTypes.JSONB,
            request: DataTypes.JSONB,
            type: DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.LabRequest
        ];
        this.upstreams = [
            models.LabRequest
        ];
        this.referencedResources = [
            models.FhirPractitioner
        ];
    }
    async updateMaterialisation() {
        const upstream = await this.getUpstream(getQueryOptions());
        const values = await getValues(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id) {
        const { LabRequest } = this.sequelize.models;
        if (upstreamTable === LabRequest.tableName) {
            return fromLabRequest(this.sequelize.models, table, id);
        }
        return null;
    }
    static async queryToFilterUpstream(upstreamTable) {
        const { LabRequest } = this.sequelize.models;
        if (upstreamTable === LabRequest.tableName) {
            return filterFromLabRequests(this.sequelize.models, upstreamTable);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ...searchParameters
        };
    }
}
_define_property(FhirSpecimen, "CAN_DO", new Set([
    FHIR_INTERACTIONS.INSTANCE.READ,
    FHIR_INTERACTIONS.TYPE.SEARCH,
    FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=FhirSpecimen.js.map