"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PortalSurveyAssignment", {
    enumerable: true,
    get: function() {
        return PortalSurveyAssignment;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _model = require("../types/model");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("../sync/buildPatientSyncFilterViaPatientId");
const _buildPatientLinkedLookupFilter = require("../sync/buildPatientLinkedLookupFilter");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let PortalSurveyAssignment = class PortalSurveyAssignment extends _Model.Model {
    forResponse() {
        return Object.assign({}, this.dataValues);
    }
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            patientId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                references: {
                    model: 'patients',
                    key: 'id'
                }
            },
            surveyId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                references: {
                    model: 'surveys',
                    key: 'id'
                }
            },
            status: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                defaultValue: _constants.PORTAL_SURVEY_ASSIGNMENTS_STATUSES.OUTSTANDING
            },
            assignedAt: (0, _model.dateTimeType)('assignedAt', {
                allowNull: false
            }),
            assignedById: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                references: {
                    model: 'users',
                    key: 'id'
                }
            },
            surveyResponseId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true,
                references: {
                    model: 'survey_responses',
                    key: 'id'
                }
            }
        }, {
            ...options,
            indexes: [
                {
                    fields: [
                        'patientId',
                        'status'
                    ],
                    name: 'idx_patient_id_status'
                }
            ],
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.Survey, {
            foreignKey: 'surveyId',
            as: 'survey'
        });
        this.belongsTo(models.User, {
            foreignKey: 'assignedById',
            as: 'assignedBy'
        });
        this.belongsTo(models.SurveyResponse, {
            foreignKey: 'surveyResponseId',
            as: 'surveyResponse'
        });
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
};
_define_property(PortalSurveyAssignment, "buildPatientSyncFilter", _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId);

//# sourceMappingURL=PortalSurveyAssignment.js.map