"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientSchema", {
    enumerable: true,
    get: function() {
        return PatientSchema;
    }
});
const _zod = require("zod");
const _constants = require("@tamanu/constants");
const _referenceDataschema = require("./referenceData.schema");
const PatientSchema = _zod.z.object({
    id: _zod.z.string(),
    displayId: _zod.z.string(),
    firstName: _zod.z.string(),
    middleName: _zod.z.string().nullish(),
    lastName: _zod.z.string(),
    dateOfBirth: _zod.z.string(),
    sex: _zod.z.enum(_constants.SEX_VALUES),
    village: _referenceDataschema.ReferenceDataSchema.nullish()
});

//# sourceMappingURL=patient.schema.js.map