"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirCodeableConcept", {
    enumerable: true,
    get: function() {
        return FhirCodeableConcept;
    }
});
const _lodash = require("lodash");
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _baseType = require("./baseType");
const _coding = require("./coding");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
let FhirCodeableConcept = class FhirCodeableConcept extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            coding: _yup.array().of(_coding.FhirCoding.asYup()).nullable().default([]),
            text: _yup.string().nullable().default(null)
        }).noUnknown();
    }
    static fake(...args) {
        const coding = Array((0, _lodash.random)(0, 3)).fill(0).map(()=>_coding.FhirCoding.fake(...args));
        return new this({
            coding,
            text: coding.map((c)=>c.display).join(' ')
        });
    }
};

//# sourceMappingURL=codeableConcept.js.map