"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Note", {
    enumerable: true,
    get: function() {
        return Note;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _dateTime = require("@tamanu/utils/dateTime");
const _Model = require("./Model");
const _buildNoteLinkedSyncFilter = require("../sync/buildNoteLinkedSyncFilter");
const _model = require("../types/model");
const _buildEncounterLinkedLookupFilter = require("../sync/buildEncounterLinkedLookupFilter");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let Note = class Note extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: {
                ...primaryKey,
                type: _sequelize.DataTypes.UUID
            },
            noteType: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            recordType: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            date: (0, _model.dateTimeType)('date', {
                allowNull: false,
                defaultValue: _dateTime.getCurrentDateTimeString
            }),
            content: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false,
                defaultValue: ''
            },
            visibilityStatus: {
                type: _sequelize.DataTypes.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            validate: {
                mustHaveValidRelationType () {
                    if (!_constants.NOTE_RECORD_TYPE_VALUES.includes(this.recordType)) {
                        throw new Error(`Note: Must have a valid record type (got ${this.recordType})`);
                    }
                },
                mustHaveValidType () {
                    if (!_constants.NOTE_TYPE_VALUES.includes(this.noteType)) {
                        throw new Error(`Note: Must have a valid note type (got ${this.noteType})`);
                    }
                }
            }
        });
    }
    static initRelations(models) {
        _constants.NOTE_RECORD_TYPE_VALUES.forEach((modelName)=>{
            this.belongsTo(models[modelName], {
                foreignKey: 'recordId',
                as: `${modelName.charAt(0).toLowerCase()}${modelName.slice(1)}`,
                constraints: false
            });
        });
        this.belongsTo(models.User, {
            foreignKey: 'authorId',
            as: 'author'
        });
        this.belongsTo(models.User, {
            foreignKey: 'onBehalfOfId',
            as: 'onBehalfOf'
        });
        this.belongsTo(models.Note, {
            foreignKey: 'revisedById',
            as: 'revisedBy',
            constraints: false
        });
    }
    static async createForRecord(recordId, recordType, noteType, content, authorId) {
        return Note.create({
            recordId,
            recordType,
            noteType,
            date: (0, _dateTime.getCurrentDateTimeString)(),
            content,
            authorId
        });
    }
    async getParentRecord(options) {
        if (!this.recordType) {
            return null;
        }
        const parentGetter = `get${this.recordType}`;
        return this[parentGetter](options);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupSelect)(this, {
                patientId: (0, _buildNoteLinkedSyncFilter.getPatientIdColumnOfNotes)()
            }),
            joins: (0, _buildNoteLinkedSyncFilter.buildNoteLinkedJoins)().join('\n')
        };
    }
};
_define_property(Note, "buildPatientSyncFilter", _buildNoteLinkedSyncFilter.buildNoteLinkedSyncFilter);

//# sourceMappingURL=Note.js.map