"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "initDeviceId", {
    enumerable: true,
    get: function() {
        return initDeviceId;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _shortid = /*#__PURE__*/ _interop_require_default(require("shortid"));
const _facts = require("@tamanu/constants/facts");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function initDeviceId({ context, deviceType }) {
    if (!deviceType) {
        throw new Error('Device type is required to initialize device ID');
    }
    const { LocalSystemFact } = context.store?.models || context.models;
    let deviceId = await LocalSystemFact.get(_facts.FACT_DEVICE_ID);
    if (!deviceId) {
        deviceId = _config.default.deviceId ?? `${deviceType}-${(0, _shortid.default)()}`;
        await LocalSystemFact.setIfAbsent(_facts.FACT_DEVICE_ID, deviceId);
    } else if (_config.default.deviceId && deviceId !== _config.default.deviceId) {
        throw new Error(`Device ID mismatch: ${deviceId} (from database) vs ${_config.default.deviceId} (from config)`);
    }
    // eslint-disable-next-line require-atomic-updates
    context.deviceId = deviceId;
}

//# sourceMappingURL=initDeviceId.js.map