"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "patientProgramRegistrationConditions", {
    enumerable: true,
    get: function() {
        return patientProgramRegistrationConditions;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _ability = require("@casl/ability");
const _errors = require("@tamanu/errors");
const _camelCaseProperties = require("@tamanu/utils/camelCaseProperties");
const _sequelize = require("sequelize");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const patientProgramRegistrationConditions = _express.default.Router();
patientProgramRegistrationConditions.put('/condition/:id', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params, body } = req;
    const { id } = params;
    req.checkPermission('read', 'PatientProgramRegistrationCondition');
    req.checkPermission('write', 'PatientProgramRegistrationCondition');
    const existingCondition = await models.PatientProgramRegistrationCondition.findOne({
        where: {
            id
        }
    });
    if (!existingCondition) {
        throw new _errors.NotFoundError('Patient program registration condition not found');
    }
    const updatedCondition = await existingCondition.update(body);
    res.send(updatedCondition);
}));
patientProgramRegistrationConditions.get('/:programRegistrationId/condition', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params } = req;
    const { programRegistrationId } = params;
    const { PatientProgramRegistrationCondition, PatientProgramRegistration, ChangeLog, User } = models;
    const programRegistration = await PatientProgramRegistration.findOne({
        where: {
            id: programRegistrationId
        }
    });
    if (!programRegistration) {
        throw new _errors.NotFoundError('PatientProgramRegistration not found');
    }
    const { programRegistryId } = programRegistration;
    req.checkPermission('read', (0, _ability.subject)('ProgramRegistry', {
        id: programRegistryId
    }));
    req.checkPermission('list', 'PatientProgramRegistrationCondition');
    const conditions = await PatientProgramRegistrationCondition.findAll({
        where: {
            patientProgramRegistrationId: programRegistrationId
        },
        include: PatientProgramRegistrationCondition.getFullReferenceAssociations(),
        order: [
            [
                'date',
                'DESC'
            ]
        ]
    });
    // Get all condition IDs
    const conditionIds = conditions.map((c)=>c.id);
    // Fetch change history for all conditions
    const changes = await ChangeLog.findAll({
        where: {
            tableName: 'patient_program_registration_conditions',
            recordId: {
                [_sequelize.Op.in]: conditionIds
            }
        },
        include: [
            {
                model: User,
                as: 'updatedByUser',
                attributes: [
                    'id',
                    'displayName'
                ]
            }
        ],
        order: [
            [
                'loggedAt',
                'DESC'
            ]
        ]
    });
    // Create a map of condition ID to its change history
    const conditionHistoryMap = changes.reduce((acc, change)=>{
        const conditionId = change.recordId;
        if (!acc[conditionId]) {
            acc[conditionId] = [];
        }
        acc[conditionId].push({
            id: change.id,
            date: change.loggedAt,
            data: (0, _camelCaseProperties.camelCaseProperties)(change.recordData),
            clinician: change.updatedByUser
        });
        return acc;
    }, {});
    // Add history to each condition
    const conditionsWithHistory = conditions.map((condition)=>({
            ...condition.toJSON(),
            history: conditionHistoryMap[condition.id] || []
        }));
    res.send({
        count: conditionsWithHistory.length,
        data: conditionsWithHistory
    });
}));

//# sourceMappingURL=patientProgramRegistrationConditions.js.map