"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    DEFAULT_SCHEMA_FOR_TYPE: function() {
        return DEFAULT_SCHEMA_FOR_TYPE;
    },
    INCLUDE_SCHEMA: function() {
        return INCLUDE_SCHEMA;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _constants = require("@tamanu/constants");
const _datetime = require("./datetime");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const SEARCH_PREFIXES_ENUM = Object.values(_constants.FHIR_SEARCH_PREFIXES);
const DEFAULT_SCHEMA_FOR_TYPE = {
    [_constants.FHIR_SEARCH_PARAMETERS.NUMBER]: _yup.object().transform(function numberParse(value, originalValue) {
        if (this.isType(value)) return value;
        const prefix = SEARCH_PREFIXES_ENUM.find((pref)=>originalValue.startsWith(pref)) || null;
        const number = originalValue.replace(new RegExp(`^${prefix}`), '');
        return {
            prefix,
            number
        };
    }).shape({
        prefix: _yup.string().oneOf([
            null,
            ...SEARCH_PREFIXES_ENUM
        ]).nullable(),
        number: _yup.number().required()
    }).noUnknown(),
    [_constants.FHIR_SEARCH_PARAMETERS.DATE]: _yup.object().transform(function dateParse(value, originalValue) {
        if (this.isType(value)) return value;
        const prefix = SEARCH_PREFIXES_ENUM.find((pref)=>originalValue.startsWith(pref)) || null;
        const date = prefix ? originalValue.slice(prefix.length) : originalValue;
        const parsed = (0, _datetime.parseDateTime)(date);
        if (parsed === false) return false;
        return {
            prefix,
            date: parsed
        };
    }).shape({
        prefix: _yup.string().oneOf([
            null,
            ...SEARCH_PREFIXES_ENUM
        ]).nullable(),
        date: _datetime.DATE_OBJECT_SCHEMA.required()
    }).noUnknown(),
    [_constants.FHIR_SEARCH_PARAMETERS.STRING]: _yup.string(),
    [_constants.FHIR_SEARCH_PARAMETERS.TOKEN]: _yup.object().transform(function tokenParse(value, originalValue) {
        if (this.isType(value)) return value;
        const [system, code] = originalValue.includes('|') ? originalValue.split('|', 2) : [
            null,
            originalValue
        ];
        return {
            system,
            code
        };
    }).shape({
        system: _yup.string().url().nullable(),
        code: _yup.string().nullable()
    }).noUnknown(),
    [_constants.FHIR_SEARCH_PARAMETERS.REFERENCE]: _yup.object().transform(function referenceParse(value, originalValue) {
        if (this.isType(value)) return value;
        try {
            return {
                url: new URL(originalValue)
            };
        } catch (_) {
            if (originalValue.includes('/')) {
                const [type, id] = originalValue.split('/', 2);
                return {
                    type,
                    id
                };
            }
            return {
                id: originalValue
            };
        }
    }).shape({
        // TODO: when yup v1 lands, do an either/or {url}/{type,id} with id required
        url: _yup.string().url().optional(),
        id: _yup.string().optional(),
        type: _yup.string().optional()
    }).noUnknown(),
    [_constants.FHIR_SEARCH_PARAMETERS.QUANTITY]: _yup.object().transform(function quantityParse(value, originalValue) {
        if (this.isType(value)) return value;
        const [quantity, system, code] = originalValue.split('|', 3);
        const prefix = SEARCH_PREFIXES_ENUM.find((pref)=>quantity.startsWith(pref)) || null;
        const number = quantity.replace(new RegExp(`^${prefix}`), '');
        return {
            prefix,
            number,
            system,
            code
        };
    }).shape({
        prefix: _yup.string().oneOf([
            null,
            ...SEARCH_PREFIXES_ENUM
        ]).nullable(),
        number: _yup.number().required(),
        system: _yup.string().url().nullable(),
        code: _yup.string().nullable()
    }).noUnknown(),
    [_constants.FHIR_SEARCH_PARAMETERS.URI]: _yup.mixed().transform(function uriParse(value, originalValue) {
        if (this.isType(value)) return value;
        try {
            return new URL(originalValue);
        } catch (_) {
            return null;
        }
    }).required()
};
const INCLUDE_SCHEMA = _yup.object().transform(function includeParse(value, originalValue) {
    if (this.isType(value)) return value;
    const [resource, parameter, targetType] = originalValue.split(':', 3);
    return {
        resource,
        parameter,
        targetType
    };
}).shape({
    resource: _yup.string().required(),
    parameter: _yup.string().required(),
    targetType: _yup.string().nullable()
}).noUnknown();

//# sourceMappingURL=schemata.js.map