"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "authModule", {
    enumerable: true,
    get: function() {
        return authModule;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _auth = require("../../auth");
const _patientPortalLogin = require("./patientPortalLogin");
const _patientPortalMiddleware = require("./patientPortalMiddleware");
const _verifyRegistration = require("./verifyRegistration");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const authModule = _express.default.Router();
authModule.post('/login', (0, _patientPortalLogin.patientPortalLogin)({
    secret: _auth.DEFAULT_JWT_SECRET
}));
authModule.post('/request-login-token', _patientPortalLogin.requestLoginToken);
authModule.post('/verify-registration', _verifyRegistration.verifyRegistration);
authModule.use((0, _patientPortalMiddleware.patientPortalMiddleware)({
    secret: _auth.DEFAULT_JWT_SECRET
}));

//# sourceMappingURL=index.js.map