"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceItemDiscount", {
    enumerable: true,
    get: function() {
        return InvoiceItemDiscount;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _buildEncounterLinkedSyncFilter = require("../sync/buildEncounterLinkedSyncFilter");
const _Model = require("./Model");
const _buildEncounterLinkedLookupFilter = require("../sync/buildEncounterLinkedLookupFilter");
const INVOICE_ITEMS_DISCOUNT_TYPE_VALUES = Object.values(_constants.INVOICE_ITEMS_DISCOUNT_TYPES);
let InvoiceItemDiscount = class InvoiceItemDiscount extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            amount: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: false
            },
            type: {
                type: _sequelize.DataTypes.ENUM(...INVOICE_ITEMS_DISCOUNT_TYPE_VALUES),
                allowNull: false,
                defaultValue: _constants.INVOICE_ITEMS_DISCOUNT_TYPES.PERCENTAGE
            },
            reason: _sequelize.DataTypes.STRING
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.InvoiceItem, {
            foreignKey: 'invoiceItemId',
            as: 'invoiceItem'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'invoice_items',
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupSelect)(this),
            joins: (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupJoins)(this, [
                'invoice_items',
                'invoices',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=InvoiceItemDiscount.js.map