"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    centralDefaults: function() {
        return centralDefaults;
    },
    centralSettings: function() {
        return centralSettings;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _definitions = require("./definitions");
const _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const centralSettings = {
    name: 'Central server settings',
    description: 'Settings that apply only to a central server',
    properties: {
        disk: {
            name: 'Disk',
            description: 'Disk settings',
            properties: {
                freeSpaceRequired: {
                    name: 'Free space required',
                    description: 'Settings related to free disk space required during uploads',
                    properties: {
                        gigabytesForUploadingDocuments: {
                            name: 'Gigabytes for uploading documents',
                            description: 'The minimum gigabytes required to upload documents',
                            type: _yup.number().positive(),
                            defaultValue: 16
                        }
                    }
                }
            }
        },
        sync: {
            description: 'Settings related to sync',
            highRisk: true,
            properties: {
                streaming: {
                    properties: {
                        enabled: {
                            description: 'Use streaming endpoints',
                            type: _yup.boolean(),
                            defaultValue: false
                        },
                        databasePollBatchSize: {
                            description: 'The number of records to poll in a single batch for a streaming endpoint',
                            type: _yup.number().positive().integer().min(1),
                            defaultValue: 100
                        },
                        databasePollInterval: {
                            description: 'The interval in milliseconds to poll the database for a streaming wait',
                            type: _yup.number().positive().integer().min(10),
                            defaultValue: 1000
                        }
                    }
                }
            }
        },
        mobileSync: {
            description: 'Settings related to mobile sync',
            highRisk: true,
            properties: {
                useUnsafeSchemaForInitialSync: {
                    description: 'Use unsafe schema for initial sync which is faster but should be turned off if large initial syncs over 3 million records',
                    type: _yup.boolean(),
                    defaultValue: true
                },
                maxBatchesToKeepInMemory: {
                    description: 'The number of batches to keep in memory during saveChanges, currently equal to n * pullIncomingChanges.maxRecordsPerSnapshotBatch',
                    type: _yup.number().positive().integer(),
                    defaultValue: 5
                },
                maxRecordsPerInsertBatch: {
                    description: 'The number of records to insert in a single batch',
                    type: _yup.number().positive().integer(),
                    defaultValue: 2000
                },
                maxRecordsPerUpdateBatch: {
                    description: 'The number of records to update in a single batch',
                    type: _yup.number().positive().integer(),
                    defaultValue: 2000
                },
                maxRecordsPerSnapshotBatch: {
                    description: 'The number of records to store within a single row in the snapshot table',
                    type: _yup.number().positive().integer(),
                    defaultValue: 1000
                },
                dynamicLimiter: {
                    description: 'Settings for the sync page size dynamic limiter',
                    properties: {
                        initialLimit: {
                            description: 'The initial limit for the dynamic limiter',
                            type: _yup.number().positive().integer(),
                            defaultValue: 10000
                        },
                        minLimit: {
                            description: 'The minimum limit for the dynamic limiter',
                            type: _yup.number().positive().integer(),
                            defaultValue: 1000
                        },
                        maxLimit: {
                            description: 'The maximum limit for the dynamic limiter',
                            type: _yup.number().positive().integer(),
                            defaultValue: 40000
                        },
                        maxLimitChangePerPage: {
                            description: 'The maximum change per page for the dynamic limiter',
                            type: _yup.number().positive().min(0).max(1),
                            defaultValue: 0.3
                        },
                        optimalTimePerPage: {
                            description: 'The optimal time per page for the dynamic limiter',
                            type: _yup.number().positive().integer(),
                            unit: 'ms',
                            defaultValue: 10000
                        }
                    }
                }
            }
        },
        questionCodeIds: {
            deprecated: true,
            description: _definitions.questionCodeIdsDescription,
            properties: {
                passport: {
                    type: _definitions.passportSchema,
                    defaultValue: null
                },
                nationalityId: {
                    type: _definitions.nationalityIdSchema,
                    defaultValue: null
                },
                email: {
                    type: _definitions.emailSchema,
                    defaultValue: null
                }
            }
        },
        reportProcess: {
            properties: {
                timeOutDurationSeconds: {
                    description: 'If generating a report takes longer than this, it will be cancelled and marked as timed out. (If this ' + 'is set to a very short duration shorter than the time between Report Request Processor runs ' + '(‘schedules.reportRequestProcessor’), it will have no effect.',
                    type: _yup.number().integer().positive(),
                    defaultValue: 7200,
                    unit: 'seconds'
                },
                runInChildProcess: {
                    description: 'True if report generation should be run in a child process, or false if it should run in the main process',
                    type: _yup.boolean(),
                    defaultValue: true
                },
                processOptions: {
                    description: "Provide an array if you want to override the options. e.g. ['--max-old-space-size=4096']",
                    type: _yup.array(_yup.string()).nullable(),
                    defaultValue: null
                },
                childProcessEnv: {
                    description: 'Provide an object {} for the env of child process',
                    type: _yup.object().nullable(),
                    defaultValue: null
                },
                sleepAfterReport: {
                    description: 'To mitigate resource-hungry reports affecting operational use of Tamanu, if a report takes too long, then report generation can be suspended for a some time',
                    properties: {
                        duration: {
                            description: 'If generating a report takes longer than ifRunAtLeast, then suspend subsequent report generation for this long',
                            type: (0, _definitions.durationStringSchema)('duration'),
                            defaultValue: '5m'
                        },
                        ifRunAtLeast: {
                            description: 'If a report takes longer than this, then temporarily suspend subsequent report generation',
                            type: (0, _definitions.durationStringSchema)('ifRunAtLeast'),
                            defaultValue: '5m'
                        }
                    }
                }
            }
        },
        integrations: {
            description: 'Integrations with external services',
            properties: {
                dhis2: {
                    description: 'DHIS2 settings',
                    properties: {
                        host: {
                            description: 'The host of the DHIS2 instance',
                            type: _yup.string().matches(/^(?!.*\/$).*$/, 'Host URL must not end with a forward slash'),
                            defaultValue: ''
                        },
                        reportIds: {
                            name: 'Reports',
                            description: 'The IDs of the reports to send to DHIS2',
                            type: _yup.array(_yup.string().min(1)),
                            defaultValue: [],
                            suggesterEndpoint: 'reportDefinition'
                        },
                        // Descriptions and allowed values taken from https://docs.dhis2.org/en/develop/using-the-api/dhis-core-version-239/data.html#webapi_data_values_import_parameters
                        idSchemes: {
                            description: 'The ID schemes to use for the reports',
                            properties: {
                                dataElementIdScheme: {
                                    name: 'Data element ID scheme',
                                    description: 'Property of the data element object to use to map the data values.',
                                    type: _definitions.dhis2IdSchemeSchema,
                                    defaultValue: 'uid'
                                },
                                orgUnitIdScheme: {
                                    name: 'Organisation unit ID scheme',
                                    description: 'Property of the org unit object to use to map the data values.',
                                    type: _definitions.dhis2IdSchemeSchema,
                                    defaultValue: 'uid'
                                },
                                categoryOptionComboIdScheme: {
                                    name: 'Category option combo ID scheme',
                                    description: 'Property of the category option combo and attribute option combo objects to use to map the data values.',
                                    type: _definitions.dhis2IdSchemeSchema,
                                    defaultValue: 'uid'
                                },
                                dataSetIdScheme: {
                                    name: 'Data set ID scheme',
                                    description: 'Property of the data set object to use to map the data values.',
                                    type: _definitions.dhis2IdSchemeSchema,
                                    defaultValue: 'uid'
                                },
                                idScheme: {
                                    name: 'ID scheme',
                                    description: 'Property of the data element object to use to map the data values.',
                                    type: _definitions.dhis2IdSchemeSchema,
                                    defaultValue: 'uid'
                                }
                            }
                        },
                        backoff: {
                            name: 'Backoff',
                            description: 'Backoff settings',
                            properties: {
                                maxAttempts: {
                                    name: 'Max attempts',
                                    description: 'The maximum number of connection attempts',
                                    type: _yup.number().integer().positive(),
                                    defaultValue: 15
                                },
                                multiplierMs: {
                                    name: 'Multiplier',
                                    description: 'The multiplier for the delay between retries',
                                    type: _yup.number().integer().positive(),
                                    defaultValue: 300,
                                    unit: 'ms'
                                },
                                maxWaitMs: {
                                    name: 'Max wait',
                                    description: 'The delay between retries',
                                    type: _yup.number().integer().positive(),
                                    defaultValue: 10000,
                                    unit: 'ms'
                                }
                            }
                        }
                    }
                }
            }
        }
    }
};
const centralDefaults = (0, _utils.extractDefaults)(centralSettings);

//# sourceMappingURL=central.js.map