"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "referenceData", {
    enumerable: true,
    get: function() {
        return referenceData;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _constants = require("@tamanu/constants");
const _errors = require("@tamanu/errors");
const _lodash = require("lodash");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const referenceData = _express.default.Router();
// Reference data relation endpoints
referenceData.get('/addressHierarchyTypes', (0, _expressasynchandler.default)(async (req, res)=>{
    req.flagPermissionChecked();
    const { models: { ReferenceData }, query: { leafNodeType, relationType = _constants.DEFAULT_HIERARCHY_TYPE } } = req;
    const entity = await ReferenceData.getNode({
        where: {
            type: leafNodeType
        },
        raw: false,
        relationType
    });
    if (!entity) {
        return res.send([]);
    }
    // The Assumption is that the address hierarchy tree is a "fully normalized tree" so that each layer
    // in the hierarchy is fully connected to the next layer across all nodes. There for the list of ancestor
    // types is the total list of types in the hierarchy.
    const ancestors = await entity.getAncestors(relationType);
    const hierarchyTypes = [
        ...ancestors,
        entity.get({
            plain: true
        })
    ].map((e)=>e.type);
    res.send(hierarchyTypes);
}));
referenceData.get('/:id/ancestors', (0, _expressasynchandler.default)(async (req, res)=>{
    req.flagPermissionChecked();
    const { models: { ReferenceData }, params: { id }, query: { relationType = _constants.DEFAULT_HIERARCHY_TYPE } } = req;
    const entity = await ReferenceData.findByPk(id);
    const ancestors = await entity.getAncestors(relationType);
    const hierarchyValues = [
        ...ancestors,
        entity.get({
            plain: true
        })
    ];
    res.send((0, _lodash.mapValues)((0, _lodash.keyBy)(hierarchyValues, 'type'), 'id'));
}));
referenceData.get('/facilityCatchment/:id/facility', (0, _expressasynchandler.default)(async (req, res)=>{
    req.flagPermissionChecked();
    const { models: { ReferenceData, Facility }, params: { id } } = req;
    const catchment = await ReferenceData.getParent(id, _constants.REFERENCE_DATA_RELATION_TYPES.FACILITY_CATCHMENT);
    if (!catchment) throw new _errors.NotFoundError();
    const facility = await Facility.findOne({
        where: {
            catchmentId: catchment.id
        }
    });
    if (!facility) throw new _errors.NotFoundError();
    res.send(facility);
}));
referenceData.get('/:id', (0, _crudHelpers.simpleGet)('ReferenceData'));
referenceData.put('/:id', (0, _crudHelpers.simplePut)('ReferenceData'));
referenceData.post('/$', (0, _crudHelpers.simplePost)('ReferenceData'));

//# sourceMappingURL=referenceData.js.map