"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "insertCovidTest", {
    enumerable: true,
    get: function() {
        return insertCovidTest;
    }
});
const _fake = require("@tamanu/fake-data/fake");
const _constants = require("@tamanu/constants");
const _chance = require("../../../chance");
const insertCovidTest = async ({ LabTest, LabRequest }, setupData, { encounterId })=>{
    const labRequest = await LabRequest.create({
        ...(0, _fake.fake)(LabRequest),
        labTestCategoryId: _chance.chance.pickone(setupData.labTestCategories).id,
        status: _chance.chance.pickone(Object.values(_constants.LAB_REQUEST_STATUSES).filter((s)=>s !== _constants.LAB_REQUEST_STATUSES.DELETED)),
        encounterId
    });
    return LabTest.create({
        ...(0, _fake.fake)(LabTest),
        labRequestId: labRequest.id,
        date: _chance.chance.date({
            year: _chance.chance.integer({
                min: 1970,
                max: 2021
            })
        })
    });
};

//# sourceMappingURL=insertCovidTest.js.map