"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE_NAME = 'patients';
const ISO9075_DATE_TIME_FMT = 'YYYY-MM-DD HH24:MI:SS';
async function up(query) {
    // 1. Create legacy columns
    await query.addColumn(TABLE_NAME, 'date_of_death_legacy', {
        type: _sequelize.DataTypes.DATE
    });
    // 2. Copy data to legacy columns for backup
    await query.sequelize.query(`
    UPDATE ${TABLE_NAME}
    SET
      date_of_death_legacy = date_of_death;
  `);
    // 3.Change column types from of original columns from date to string & convert data to string
    await query.sequelize.query(`
    ALTER TABLE ${TABLE_NAME}
    ALTER COLUMN date_of_death TYPE date_time_string USING TO_CHAR(date_of_death, '${ISO9075_DATE_TIME_FMT}');
`);
}
async function down(query) {
    await query.sequelize.query(`
    ALTER TABLE ${TABLE_NAME}
    ALTER COLUMN date_of_death TYPE timestamp with time zone USING date_of_death_legacy;
  `);
    await query.removeColumn(TABLE_NAME, 'date_of_death_legacy');
}

//# sourceMappingURL=091_alterPatientDateOfDeathDateField.js.map