export const initAuditActions = (req, params)=>({
        access: async ({ recordId, frontEndContext = {}, model })=>{
            if (!params.enabled) return;
            return req.models.AccessLog.create({
                sessionId: req.sessionId,
                deviceId: req.deviceId ?? 'unknown-device',
                facilityId: req.facilityId ?? null,
                backEndContext: {
                    endpoint: req.originalUrl,
                    ...params.backEndContext
                },
                frontEndContext,
                userId: params.userId,
                version: params.version,
                isMobile: params.isMobile ?? false,
                recordType: model.name,
                recordId,
                loggedAt: new Date()
            });
        }
    });

//# sourceMappingURL=initAuditActions.js.map