/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _constants = require("@tamanu/constants");
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('invoices', 'insurer_payment_status', {
        type: _sequelize.DataTypes.STRING,
        allowNull: false,
        defaultValue: _constants.INVOICE_INSURER_PAYMENT_STATUSES.UNPAID
    });
}
async function down(query) {
    await query.removeColumn('invoices', 'insurer_payment_status');
}

//# sourceMappingURL=1720085788151-addInsurerPaymentStatusToInvoice.js.map