"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _constants = require("@tamanu/constants");
// Note that we want to populate the column with an array with only the sync client scope
const INITIAL_DEVICE_SCOPES = [
    _constants.DEVICE_SCOPES.SYNC_CLIENT
];
async function up(query) {
    await query.sequelize.query(`
    INSERT INTO devices (id, last_seen_at, scopes, registered_by_id)
    SELECT device_id, now(), $deviceScopes, $systemUserUuid FROM sync_device_ticks GROUP BY device_id;
  `, {
        bind: {
            deviceScopes: JSON.stringify(INITIAL_DEVICE_SCOPES),
            systemUserUuid: _constants.SYSTEM_USER_UUID
        }
    });
}
async function down(query) {
    await query.sequelize.query(`
    DELETE FROM devices;
  `);
}

//# sourceMappingURL=1756167650873-populateDevicesTable.js.map