import { SettingPath } from '../types';
import { Models } from './readers/SettingsDBReader';
export declare const KEYS_EXPOSED_TO_FRONT_END: readonly ["audit", "appointments", "ageDisplayFormat", "customisations", "features", "fields", "imagingCancellationReasons", "imagingPriorities", "insurer", "customisations", "printMeasures", "invoice", "labsCancellationReasons", "templates", "layouts", "triageCategories", "upcomingVaccinations", "vaccinations", "vitalEditReasons", "medications", "sync", "mobileSync"];
export declare class ReadSettings<Path = SettingPath> {
    models: Models;
    facilityId?: string;
    constructor(models: Models, facilityId?: string);
    get<T extends string | number | object>(key: Path): Promise<T>;
    getFrontEndSettings(): Promise<{
        [x: string]: string | number | object;
    }>;
    getAll(): Promise<{
        [x: string]: string | number | object;
    }>;
}
