"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createAdministeredVaccine: function() {
        return createAdministeredVaccine;
    },
    createScheduledVaccine: function() {
        return createScheduledVaccine;
    }
});
const _chance = require("chance");
const _constants = require("@tamanu/constants");
const _generateId = require("@tamanu/utils/generateId");
const chance = new _chance.Chance();
async function createScheduledVaccine(models, overrides = {}) {
    return {
        id: (0, _generateId.generateId)(),
        category: chance.pickone(_constants.VACCINE_CATEGORIES_VALUES),
        label: chance.animal(),
        doseLabel: chance.pickone([
            'Dose 1',
            'Dose 2',
            'Dose 3'
        ]),
        ...overrides
    };
}
async function createAdministeredVaccine(models, overrides = {}) {
    return {
        id: (0, _generateId.generateId)(),
        batch: chance.tv(),
        status: 'GIVEN',
        date: new Date(),
        ...overrides
    };
}

//# sourceMappingURL=vaccines.js.map